/**
 * ab_google_maps package for Concrete5
 * Copyright Copyright 2018-2019, Alex Borisov
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * @author Alex Borisov <linuxoidoz@gmail.com>
 * @package Concrete\Package\ab_google_maps
 */

$(document).ready(function(e) {
    if(CCM_EDIT_MODE){
        return;
    }
    
    $.each($('.ab-google-map[data-jq]'), function(index, element) {
        var jq_data = $.parseJSON($(element).attr('data-jq'));
        InitGoogleMap(element, jq_data);
    });

    function InitGoogleMap(element, jq_data) {
        var myGoogleBalloon = '<div class="my-balloon">';
        if (jq_data.show_picture) {
            myGoogleBalloon += '<div class="left">';
            myGoogleBalloon += '<img src="' + jq_data.picture + '" />';
            myGoogleBalloon += '</div>';
        }
        myGoogleBalloon += '<div class="right">'; 
        myGoogleBalloon += '<h3>' + jq_data.name + '</h3>';
        myGoogleBalloon += jq_data.show_address ? ('<strong>' + jq_data.t_address + '</strong> ' + jq_data.address + '<br />') : '';
        myGoogleBalloon += jq_data.show_tel ? ('<strong>' + jq_data.t_tel + '</strong> ' + jq_data.tel + '<br />') : '';
        myGoogleBalloon += jq_data.show_email ? ('<strong>' + jq_data.t_email + '</strong> <a href="mailto:' + jq_data.email + '">' + jq_data.email + '</a>') : '';
        myGoogleBalloon += '</div>';
        myGoogleBalloon += '</div>';
            
        var myGoogleMap, myGooglePopUp, myGooglePlacemark;
        var lat = parseFloat(jq_data.latitude);
        var lon = parseFloat(jq_data.longitude);
        var zoom = jq_data.zoom != '' ? parseInt(jq_data.zoom) : 0;

        myGoogleMap = new google.maps.Map(element, {
            center: {
                lat: lat,
                lng: lon,
            },
            zoom: zoom > 0 ? zoom : 16,
            gestureHandling : jq_data.lock_wheel ? 'cooperative' : 'greedy',
        });
        
        var myGooglePopUp = new google.maps.InfoWindow({
            content: myGoogleBalloon,
        });
        
        myGooglePlacemark = new google.maps.Marker({
            position: {
                lat: lat,
                lng: lon,
            },
            map: myGoogleMap,
            title: jq_data.name,
        });
        myGooglePlacemark.addListener('click', function() {
          myGooglePopUp.open(myGoogleMap, myGooglePlacemark);
        });
    };
});
