<?php namespace Concrete\Package\LiveChat;

use Concrete\Package\LiveChat\Src\LiveChatConfig;
use Events;
use Localization;
use Package;
use Page;
use SinglePage;
use View;

defined('C5_EXECUTE') or die("Access Denied.");

class Controller extends Package
{
	protected $pkgHandle = 'live_chat';
	protected $appVersionRequired = '5.7.1';
	protected $pkgVersion = '1.0.1';

	public function getPackageName()
	{
		return t('Live Chat');
	}

	public function getPackageDescription()
	{
		return t('Message Your Visitors in Real Time');
	}

	public function install()
	{
		$package = parent::install();
		$this->installSinglePages($package);
		LiveChatConfig::save('widget.pageID', '');
		LiveChatConfig::save('widget.type', '');
		LiveChatConfig::save('widget.hide', false);
		LiveChatConfig::save('widget.hide_edit_mode', true);
		LiveChatConfig::save('widget.hide_dashboard', true);
		LiveChatConfig::save('widget.use_cache', false);
	}

	public function upgrade()
	{
		$package = $this;
		$this->installSinglePages($package);
		parent::upgrade();
	}

	protected function installSinglePages($package)
	{
		$singlePages = [
			[
				'path'  => sprintf('/dashboard/system/%s', $this->pkgHandle),
				'cName' => t('Live Chat'),
			],
			[
				'path'  => sprintf('/dashboard/system/%s/settings', $this->pkgHandle),
				'cName' => t('Settings'),
			],
			[
				'path'  => sprintf('/dashboard/system/%s/multilingual_setup', $this->pkgHandle),
				'cName' => t('Multilingual Setup'),
			],
		];
		foreach ($singlePages as $singlePage) {
			$singlePageObject = Page::getByPath($singlePage['path']);
			// Check if it exists, if not, add it
			if ($singlePageObject->isError() || (!is_object($singlePageObject))) {
				$sp = SinglePage::add($singlePage['path'], $package);
				unset($singlePage['path']);
				if (!empty($singlePage)) {
					// And make sure we update the page with the remaining values
					$sp->update($singlePage);
				}
			}
		}
	}

	public function on_start()
	{
		Events::addListener('on_before_render', function () {
			$activeLocale = Localization::activeLanguage();
			$pageIDLocale = LiveChatConfig::get('widget.locale.' . $activeLocale . '.pageID');
			// First, we try and grab the page ID of the locale, then the default page ID
			if (trim($pageIDLocale) != '') {
				$pageID = $pageIDLocale;
			} else {
				$activeLocale = false;
				$pageID = LiveChatConfig::get('widget.pageID');
			}
			if (trim($pageID) != '') {
				$c = Page::getCurrentPage();
				$hide = LiveChatConfig::get('widget.hide');
				$isAdminArea = $c && $c->isAdminArea();
				$isEditMode = $c && $c->isEditMode();
				$show = (!$hide && !$isAdminArea && $isEditMode && LiveChatConfig::get('widget.hide_edit_mode') !== true) || (!$isEditMode && !$isAdminArea && !$hide) || ($isAdminArea && LiveChatConfig::get('widget.hide_dashboard') !== true) ? true : false;
				if ($show) {
					$type = $activeLocale ? LiveChatConfig::get('widget.locale.' . $activeLocale . '.type') : LiveChatConfig::get('widget.type');
					// In case we have an empty type, just set it back to default
					if (trim($type) == '') {
						$type = 'default';
					}
					$v = View::getInstance();
					$v->addFooterItem('<!--Start of Tawk.to Script-->
<script type="text/javascript">
var $_Tawk_API={},$_Tawk_LoadStart=new Date();
(function(){
var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];
s1.async=true;
s1.src="' . LiveChatConfig::getScriptSource($pageID, $type) . '";
s1.charset="UTF-8";
s1.setAttribute("crossorigin","*");
s0.parentNode.insertBefore(s1,s0);
})();
</script>
<!--End of Tawk.to Script-->');
				}
			}
		});
	}
}