<?php   defined('C5_EXECUTE') or die("Access Denied.");
$formPageSelector = Core::make('helper/form/page_selector');?>

<div class="form-group">
	<?php  echo $form->label('buttonText', t('Button Text'));?> <span style="color:#f00"><small>(<?php  echo t('Required')?>)</small></span>
	<?php   echo $form->text('buttonText', $buttonText)?>
</div>

<div class="form-group">
	<?php   echo $form->label('buttonType', t('Button Type'))?>
	<?php   echo $form->select('buttonType', array('level1'=>t('Level 1'), 'level2'=>t('Level 2'), 'level3'=>t('Level 3'), 'level4'=>t('Level 4')), $buttonType);?>
</div>

<div class="form-group">
	<?php   echo $form->label('linkType', t('Button Link'))?>
	<select name="linkType" data-select="feature-link-type" class="form-control">
		<option value="1" <?php   echo (empty($externalLink) && !empty($internalLinkCID) ? 'selected="selected"' : '')?>><?php   echo t('Another Page')?></option>
		<option value="2" <?php   echo (!empty($externalLink) ? 'selected="selected"' : '')?>><?php   echo t('External URL')?></option>
	</select>
</div>

<div data-select-contents="feature-link-type-internal" style="display: none;" class="form-group">
	<?php  echo $form->label('internalLinkCID', t('Choose Page'));?> <span style="color:#f00"><small>(<?php  echo t('Required')?>)</small></span>
	<?php    echo $formPageSelector->selectPage('internalLinkCID',$internalLinkCID); ?>
</div>

<div data-select-contents="feature-link-type-external" style="display: none;" class="form-group">
	<?php  echo $form->label('externalLink', t('External URL'));?> <span style="color:#f00"><small>(<?php  echo t('Required')?>)</small></span>
	<?php   echo $form->text('externalLink', $externalLink); ?>
</div>

<div class="form-group">
	<?php   echo $form->label('target', t('Target'))?>
	<?php   echo $form->select('target', array('_self'=>t('Same Window'), '_blank'=>t('New Window')), $target);?>
</div>

<script type="text/javascript">
$(function() {
    $('div.ccm-block-feature-select-icon').on('change', 'select', function() {
        var $preview = $('i[data-preview=icon]');
            icon = $(this).val();

        $preview.removeClass();
        if (icon) {
            $preview.addClass('fa fa-' + icon);
        }
    });
    
	$('select[data-select=feature-link-type]').on('change', function() {
	   if ($(this).val() == '0') {
	       $('div[data-select-contents=feature-link-type-internal]').hide();
	       $('div[data-select-contents=feature-link-type-external]').hide();
	   }
	   if ($(this).val() == '1') {
	       $('div[data-select-contents=feature-link-type-internal]').show();
	       $('div[data-select-contents=feature-link-type-external]').hide();
	   }
	   if ($(this).val() == '2') {
	       $('div[data-select-contents=feature-link-type-internal]').hide();
	       $('div[data-select-contents=feature-link-type-external]').show();
	   }
	}).trigger('change');
});
</script>