<?php namespace Concrete\Package\LiveChat\Controller\SinglePage\Dashboard\System\LiveChat;

defined('C5_EXECUTE') or die("Access Denied.");

use AssetList;
use Concrete\Core\Multilingual\Page\Section\Section;
use Concrete\Core\Page\Controller\DashboardPageController;
use Concrete\Package\LiveChat\Src\LiveChatConfig;
use Request;
use Symfony\Component\HttpFoundation\JsonResponse;

class MultilingualSetup extends DashboardPageController
{
	protected $packageHandle = 'live_chat';

	public function view($locale = '')
	{
		$locales = [];
		$localeSections = Section::getList();
		foreach ($localeSections as &$localeSection) {
			$localeSectionLanguage = $localeSection->getLanguage();
			$localeSectionLanguageText = $localeSection->getLanguageText();
			$locales[$localeSectionLanguage] = $localeSectionLanguageText;
			$localePageID = LiveChatConfig::get('widget.locale.' . $localeSectionLanguage . '.pageID');
			$localeType = LiveChatConfig::get('widget.locale.' . $localeSectionLanguage . '.type');
			$localeSection->configured = trim($localePageID) != '' && trim($localeType) != '' ? true : false;
		}
		if (trim($locale) != '' && array_key_exists($locale, $locales)) {
			$baseURL = LiveChatConfig::getBaseURL();
			$pageID = LiveChatConfig::get('widget.locale.' . $locale . '.pageID');
			$type = LiveChatConfig::get('widget.locale.' . $locale . '.type');
			$queryData = array(
				'currentWidgetId'       => $type,
				'currentPageId'         => $pageID,
				'transparentBackground' => '1',
			);
			$iFrameURL = sprintf('%s/generic/widgets', $baseURL);
			if (!empty($queryData)) {
				$iFrameURL .= '?' . http_build_query($queryData);
			}
			$al = AssetList::getInstance();
			$al->register('css', 'live-chat', 'css/liveChat.css', [], $this->packageHandle);
			$this->requireAsset('css', 'live-chat');
			$this->set('iFrameURL', $iFrameURL);
			$this->set('baseURL', $baseURL);
			$this->set('locale', $locale);
			$this->set('localeText', $locales[$locale]);
		} else {
			$this->set('localeSections', $localeSections);
		}
	}

	public function set_widget($locale = '')
	{
		$errors = [];
		$post = Request::post();
		$success = false;
		if (!isset($post['pageId']) || trim($post['pageId']) == '') {
			$errors[] = t('The %s field is required.', t("Site"));
		} elseif (preg_match('/^[0-9A-Fa-f]{24}$/', $post['pageId']) !== 1) {
			$errors[] = t('The %s field has an incorrect value.', t("Site"));
		}
		if (!isset($post['widgetId']) || trim($post['widgetId']) == '') {
			$errors[] = t('The %s field is required.', t("Widget"));
		} elseif (preg_match('/^[a-z0-9]{1,50}$/i', $post['widgetId']) !== 1) {
			$errors[] = t('The %s field has an incorrect value.', t("Widget"));
		}
		if (trim($locale) == '') {
			$errors[] = t('The %s field is required.', t("Locale"));
		} elseif (1 !== 1) {
			$errors[] = t('The %s field has an incorrect value.', t("Locale"));
		}
		if (empty($errors)) {
			$success = true;
			LiveChatConfig::save('widget.locale.' . $locale . '.pageID', $post['pageId']);
			LiveChatConfig::save('widget.locale.' . $locale . '.type', $post['widgetId']);
		}
		return new JsonResponse(
			array(
				'success' => $success,
				'errors'  => $errors,
			)
		);
	}

	public function remove_widget($locale = '')
	{
		LiveChatConfig::save('widget.locale.' . $locale . '.pageID', '');
		LiveChatConfig::save('widget.locale.' . $locale . '.type', '');
		return new JsonResponse(
			[
				'success' => true,
			]
		);
	}
}