<?php namespace Concrete\Package\TallacmansSitename\Block\TallacmansSitename;

defined("C5_EXECUTE") or die("Access Denied.");

use Concrete\Core\Block\BlockController;
use Concrete\Core\File\File;
//use Page;

class Controller extends BlockController
{
    protected $btExportFileColumns = ['logoIcon'];
    protected $btTable = 'btTallacmansSitename';
    protected $btInterfaceWidth = 400;
    protected $btInterfaceHeight = 500;
    protected $btDefaultSet = 'basic';
    protected $pkg = 'tallacmans_sitename';

    public function getBlockTypeDescription()
    {
        return t("A controllable way to display your site name and a logo.");
    }

    public function getBlockTypeName()
    {
        return t("Tallacmans Sitename");
    }
    public function on_start() {
       $this->set('app', $this->app);
    }
    public function view()
    {
        if ($this->logoIcon && ($f = File::getByID($this->logoIcon)) && is_object($f)) {
            $this->set("logoIcon", $f);
        } else {
            $this->set("logoIcon", false);
        }
    }

    public function add()
    {
        $this->addEdit();
    }

    public function edit()
    {
        $this->addEdit();
    }

    protected function addEdit()
    {
        $this->set("alignment_options", [
            'image-left' => t("Image Left"),
            'image-right' => t("Image Right"),
            'image-top' => t("Image Top"),
            'image-bottom' => t("Image Bottom")
          ]
        );
    }

    public function validate($data) {
       $e = $this->app->make('error');

   if(empty($data['logoIcon']) && (empty($data['displaySitename']))){
          $e->add(t("You must choose an icon and/or enter a sitename."));
      }

    return $e;
  }
}
