<?php namespace Concrete\Package\LiveChat\Src;

defined('C5_EXECUTE') or die("Access Denied.");

use Config;
use Core;

class LiveChatConfig
{
	protected static $baseURL = 'https://plugins.tawk.to';
	protected static $embedURL = 'https://embed.tawk.to';
	protected static $packageHandle = 'live_chat';
	protected static $cacheMinutes = 30;

	public static function get($key, $packageHandle = false)
	{
		if (!$packageHandle) {
			$packageHandle = self::$packageHandle;
		}
		return Config::get($packageHandle . '.' . $key);
	}

	public static function save($key, $value, $packageHandle = false)
	{
		if (!$packageHandle) {
			$packageHandle = self::$packageHandle;
		}
		Config::save($packageHandle . '.' . $key, $value);
	}

	public static function getBaseURL()
	{
		return self::$baseURL;
	}

	public static function getCacheMinutes()
	{
		return self::$cacheMinutes;
	}

	public static function getScriptSource($pageID, $type)
	{
		$fileLocation = $pageID . '/' . $type;
		$scriptSource = self::$embedURL . '/' . $fileLocation;
		if (self::get('widget.use_cache') === true) {
			$f = new \Concrete\Core\File\Service\File();
			$useLive = true;
			$regenerate = true;
			$cacheDir = DIRNAME_APPLICATION . '/files/cache/live_chat/';
			$directories = [$cacheDir, $cacheDir . $pageID];
			foreach ($directories as $directory) {
				if (!file_exists($directory)) {
					mkdir($directory, 0777, true);
				}
			}
			$fileLocationFile = $cacheDir . $fileLocation . '.js';
			// Make sure the file exists and it actually has content in it && if the file is younger than [xx] minutes, we don't need to regenerate or use the live version, we use cache
			if (($fileGetContents = $f->getContents($fileLocationFile)) && trim($fileGetContents) != '' && time() - filemtime($fileLocationFile) < (60 * self::getCacheMinutes())) {
				$regenerate = false;
				$useLive = false;
			}
			if ($regenerate && ($fileGetContentsLive = $f->getContents($scriptSource)) && trim($fileGetContentsLive) != '') {
				// If we may regenerate and we got content, clear the file and append the contents
				$f->clear($fileLocationFile);
				$f->append($fileLocationFile, $fileGetContentsLive);
				$useLive = false;
			}
			if (!$useLive) {
				$scriptSource = rtrim((string)Core::make('url/canonical'), '/') . '/' . $fileLocationFile;
			}
		}
		return $scriptSource;
	}
}