<?php
namespace Concrete\Package\Sudoku;

use Package;
use BlockType;
use AssetList;

class Controller extends Package
{
    protected $pkgHandle = 'sudoku';
    protected $appVersionRequired = '8.1.0';
    protected $pkgVersion = '1.0.0';

    public function getPackageDescription()
    {
        return t('Sudoku game');
    }

    public function getPackageName()
    {
        return t('Sudoku');
    }

    public function install()
    {
        $pkg = parent::install();
        BlockType::installBlockType('sudoku', $pkg);
    }

    public function on_start()
    {
        $this->registerAssets();
    }

    private function registerAssets()
    {
        $al = AssetList::getInstance();
        $al->register('css', 'sudoku', 'css/sudoku-main.css', [], $this);
        $al->register('javascript', 'sudoku', 'js/sudoku.js', [], $this);
        $al->register('javascript', 'sudoku-init', 'js/sudoku-init.js', [], $this);
        $al->registerGroupMultiple([
            'sudoku' => [
                [
                    ['javascript', 'jquery'],
                    ['javascript', 'jquery/ui'],
                    ['javascript-localized', 'jquery/ui'],
                    ['javascript', 'sudoku'],
                    ['javascript', 'sudoku-init'],
                    ['css', 'sudoku'],
                    ['css', 'jquery/ui'],
                ],
            ],
        ]);
    }
}
